function [sfverts,sverts,t_out] = syn_scale(dist_data,rverts,t_out)
%This function takes the rotated synaptic vectors and then flattens and
%scales the synapse so that the termini all lie upon the median of the
%ori-termi distance set.
%Synatax:   [sverts,t_out] = syn_scale(dist_data,rverts,t_out)
%Input:     dist_data = The function need a list of distances that match
%               rotated vertices.  You can get the list of distances,
%               either from the alldata or ndata structures generated by 
%               pun_colo_all, or by using the index and punc_data or
%               all_data.  Both ways the matched distance should be
%               straight forward
%           rverts = the rotated vertices generated by syn_align_all.
%           t_out = the output rotated termini, we will scale this point as
%               well as a sanity check, because after scaling the t_out
%               should be just a vector of a single number
%Output:    sverts = the scaled rotated vertices.
%           sfverts = the scaled and flattened vertices
%           t_out = the scaled termi vertices.

%lets calculate the scaling factor
sfactor = repmat(median(dist_data),size(dist_data,1),1)./dist_data;
sfactor = repmat(sfactor,1,3);  %make it by x,y,z

%lets scale the data sets
t_out = t_out.*sfactor;
sverts = rverts.*sfactor;

%now flaten the rverts
sfverts = flat_verts(sverts);   %hmm shorter than expected.